/*
 * TofBetaRigCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaRigCut.cpp The TofBetaRigCut class implementation file */

#include "TofBetaRigCut.h"

int TofBetaRigCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  Int_t seqno = trkTrack->GetSeqNo();
  Int_t ntrack_tof = 0;
  for (Int_t i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == seqno)
      ntrack_tof = i;
  }
  Float_t betaModTof = fabs(event->GetToFLevel2()->CalcBeta(ntrack_tof, 10., 10., 20.)); // beta[12]

  //  Float_t rigMod = _mass*fabs(beta)*pow((1-pow(beta,2)),-0.5)/abs(_charge);

  Float_t betaModTrk = (trkTrack->GetRigidity() * abs(_charge)) / pow(pow(trkTrack->GetRigidity() * _charge, 2) + pow(
      _mass, 2), 0.5);

#ifdef DEBUGPAMCUT

  h_trk_vs_tof_betamod[0]->Fill(betaModTof,betaModTrk);

#endif

  if (fabs(betaModTof - betaModTrk) > _threshold * betaModTof) {
    return 0;
  }

#ifdef DEBUGPAMCUT

  h_trk_vs_tof_betamod[1]->Fill(betaModTof,betaModTrk);

#endif

  return CUTOK;
}
