/*
 * TofCuts.h
 *
 *  Created on: 15-mag-2009
 *      Author: Nicola Mori
 */

/*! @file TofCuts.h This header contains the inclusion of all Tof cuts. */

#ifndef TOFCUTS_H_
#define TOFCUTS_H_

#include "TofBetaCut/TofBetaCut.h"           // ToF Beta determination
#include "TofBetaRangeCut/TofBetaRangeCut.h" // ToF Beta range
#include "TofBetaRigCut/TofBetaRigCut.h"     // Match between TOF beta modulus and TRK rigidity modulus
#include "TofDedxS1Cut/TofDedxS1Cut.h"       // ToF S1 energy release
#include "TofNucleiZCut/TofNucleiZCut.h"     // Particle 's charge cut based on TofNuclei
#include "TofPatternCut/TofPatternCut.h"     // ToF pattern
#include "TofQualCut/TofQualCut.h"           // ToF quality (minimum hit paddles)
#include "TofTopS1Cut/TofTopS1Cut.h"         // ToF S1 topology (maximum hit PMTs)

#endif /* TOFCUTS_H_ */
