/*
 * TofTopS1Cut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofTopS1Cut.cpp The TofTopS1Cut class implementation file */

#include "TofTopS1Cut.h"

int TofTopS1Cut::Check(PamLevel2 *event) {

  // Array initialization
  for (int ipl = 0; ipl < 2; ipl++) {
    _nHitPmtPl[ipl] = 0;
  }

  Int_t pmtId = -1;
  Int_t layerId = 10; // valid values are 0 to 5
  
  // Compute the number of hit PMT on each plane
  for (int ih = 0; ih < event->GetToFLevel2()->npmt(); ih++) { // Int_t mandatory
    pmtId = event->GetToFLevel2()->GetToFPMT(ih)->pmt_id;
    layerId = event->GetToFLevel2()->GetPlaneIndex(pmtId);
    if (0 <= layerId && layerId < 2)
      _nHitPmtPl[layerId]++;
  }

  // CUT on hit PMTs
  for (int ipl = 0; ipl < 2; ipl++) { // check done only for S1 layers
    if (!(_nHitPmtPl[ipl] < 3))
      return 0;
  }

  return CUTOK;
}
