/*
 * NDnTrigCut.h
 *
 *  Created on: 25-feb-2010
 *      Author: S. Ricciarini
 */

/*! @file NDnTrigCut.h The NDnTrigCut class definition file */

#ifndef NDNTRIGCUT_H_
#define NDNTRIGCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The cut on ND number of neutrons (during trigger). */
class NDnTrigCut: public PamCut {
public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param nMin The lower threshold on allowed number of neutrons (default: 0).
   * @param nMax The upper threshold on allowed number of neutrons (default: 1000000000. i.e. any value).
   */
  NDnTrigCut(const char *cutName, Float_t nMin = 0., Float_t nMax = 1000000000.) :
    PamCut(cutName), _nMin(nMin), _nMax(nMax) {
  }

  /*! @brief Destructor. */
  ~NDnTrigCut() {
  }

  /*! @brief Apply the neutron count cut.
   *
   * This routine accepts only events for which the number of neutrons n (during trigger) is such that nMin <= n <= nMax
   * @param event The event to analyze.
   * @return CUTOK if nMin <= n <= nMax, 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:
  float _nMin, _nMax;

};

#endif /* NDNTRIGCUT_H_ */
