/*
 * TrackRedGeomCut.cpp
 *
 *  Created on: 30-nov-2009
 *      Author: Sergio Ricciarini
 */

/*! @file TrackRedGeomCut.cpp The TrackRedGeomCut class implementation file */

#include "TrackRedGeomCut.h"

int TrackRedGeomCut::Check(PamLevel2 *event) {

  if ( (!(_xCaloAxis) || !(_yCaloAxis)) && !(_pamTrack) ) { // check that one of the two possible initializations has been correctly done
    return 0;
  }

  if (!(_pamTrack)) { // CALOAXIS track

    Double_t xCaloTrack;
    Double_t yCaloTrack;

    for (Int_t igf = 0; igf < TrkParams::nGF; igf++) {
      xCaloTrack = _xCaloAxis->par[0] + (_xCaloAxis->par[1]) * TrkParams::zGF[igf]; // cm
      if (! (- _xDim/2. < xCaloTrack && xCaloTrack < _xDim/2.) ) {
        return 0;
      }

      yCaloTrack = _yCaloAxis->par[0] + (_yCaloAxis->par[1]) * TrkParams::zGF[igf]; // cm
      if (! (- _yDim/2. < yCaloTrack && yCaloTrack <  _yDim/2.) ) {
        return 0;
      }
    }

  }

  if (_pamTrack) { // PAMELA track

    TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

    for (int igf = 0; igf < TrkParams::nGF; igf++) { // loop on GF planes

      // check done for all 14 planes
      if (!(- _xDim/2. < trkTrack->xGF[igf] && trkTrack->xGF[igf] < _xDim/2.))
        return 0;
      if (!(- _yDim/2. < trkTrack->yGF[igf] && trkTrack->yGF[igf] < _yDim/2.))
        return 0;

    } // end loop on GF planes
    
  }

  return CUTOK;

}
