/*
 * PktQualCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file PktQualCut.h The PktQualCut class definition file */

#ifndef PKTQUALCUT_H_
#define PKTQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @enum PKT_Return Return values for rejected events */
enum PKT_Return {
  PKT_NEWRUN, ///< Discarded because it is the first event of the run.
  PKT_INVALID
///< Discarded because the packet number is not valid.
};

using std::numeric_limits;
/*! @brief The packet number quality cut.
 *
 * This cut rejects events whose packet number is less than that of the previous event.
 * When a new run starts, the previous packet number is set to the current one and the
 * current event (ie., the first event of the run) is discarded.
 */
class PktQualCut: public PamCut {

public:
  /*! @brief Constructor. */
  PktQualCut(const char *cutName) :
    PamCut(cutName), _previousPkt(numeric_limits<UInt_t>::max()), _previousRun(numeric_limits<UInt_t>::max()) {
  }
  /*! @brief Destructor. */
  ~PktQualCut() {
  }

  /*! @brief The packet number quality check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if packet number > previous packet number.
   * @return #PKT_NEWRUN if the event has been discarded since it is the first of the run
   * @return #PKT_INVALID if packet number > previous packet number.
   */
  int Check(PamLevel2 *event);

private:
  UInt_t _previousPkt;
  UInt_t _previousRun;

};

#endif /* PKTQUALCUT_H_ */
