/*
 * OBTPktNumCut.cpp
 *
 *  Created on: 18/mar/2010
 *      Author: Nicola Mori
 */

#include "OBTPktNumCut.h"

OBTPktNumCut::OBTPktNumCut(const char *cutName, vector<pair<unsigned int, unsigned int> > &list) :
  PamCut(cutName), _list(list) {
}

OBTPktNumCut::OBTPktNumCut(const char *cutName, TString listFileName) :
  PamCut(cutName) {
  ifstream listFile(listFileName);

  pair<unsigned int, unsigned int> buffer;

  /* File layout:
   *          OBT      PktNum */
  while (listFile >> buffer.first >> buffer.second) {
    _list.push_back(buffer);
  }

  listFile.close();
}

int OBTPktNumCut::Check(PamLevel2 *event) {

  if (_list.size() == 0)
    return 0; // No more couples left in the list

  unsigned int OBT = event->GetOrbitalInfo()->OBT;
  unsigned int pktNum = event->GetOrbitalInfo()->pkt_num;

  vector<pair<unsigned int, unsigned int> >::iterator currPair = _list.begin();
  while (currPair->first != OBT && currPair->second != pktNum){
    currPair++;
    if (currPair > _list.end())
      return 0; // Event not found in the list
  }

  _list.erase(currPair); // Don't search anymore for the current pair (already found)

  return CUTOK;
}
