/*
 * LTGeoFillCut.cpp
 *
 *  Created on: 26-mar-2009
 *      Author: Nicola Mori
 *  Last update: 30-apr-2009, S. Ricciarini
 */

/*! @file LTGeoFillCut.cpp The TrkRigGeoCut class implementation file */

#include "LTGeoFillCut.h"

int LTGeoFillCut::Check(PamLevel2 *event) {

  float thresholdRig = _thresholdCoeff * event->GetOrbitalInfo()->GetCutoffSVL();

  if (thresholdRig >= _binning[_binning.size() - 1] ||
      thresholdRig < _binning[0]) {

    return 0;
  }

  return CUTOK;
}

void LTGeoFillCut::OnGood(PamLevel2 *event) {

  float ltime=0.16 * (float) (event->GetTrigLevel2()->dltime[0]) / 1000.; // seconds
  _histogram_tot += ltime;

  float thresholdRig = _thresholdCoeff * event->GetOrbitalInfo()->GetCutoffSVL();

  //Bin upper limit identification
  int i = 1;
  while (thresholdRig >= _binning[i]){
    i++;
  }

  _histogram[i-1] += ltime; // seconds

}
