/*
 * LShellCut.h
 *
 *  Created on: 14-jan-2010
 *      Author: S. Ricciarini
 */

/*! @file LShellCut.h The LShellCut class definition file */

#ifndef LSHELLCUT_H_
#define LSHELLCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The L shell cut. */
class LShellCut: public PamCut {
public:

  /*! @brief Constructor.
   *
   *
   * @param cutName The cut's name.
   * @param LShellMin The minimum threshold value of the L shell (in units of earth radius).
   * @param LShellMax The maximum threshold value of the L shell (in units of earth radius). If 0, only the
   *                  lower threshold will be checked.
   */
  LShellCut(const char *cutName, Float_t LShellMin, Float_t LShellMax = 0.) :
    PamCut(cutName), _LShellMin(LShellMin), _LShellMax(LShellMax) {
  }


  /*! @brief Destructor. */
  ~LShellCut() {
  }

  /*! @brief Apply the L shell cut.
   *
   * This routine rejects the events whose L shell value is outside the parameters passed to the constructor.
   * @param event The event to analyze.
   * @return CUTOK if LShellMin < LShell < LShellMax (LShellMax check is done only if LShellMax > 0).
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:
  float _LShellMin, _LShellMax;

};

#endif /* LSHELLCUT_H_ */
