/*
 * InclInfoQualCut.cpp
 *
 *  Created on: 27-marth-2010
 *     Author: Vitaly Malakhov
 */

/*! @file InclInfoQualCut.cpp The InclInfoQualCut class implementation file */

#include "InclInfoQualCut.h"

int InclInfoQualCut::Check(PamLevel2 *event) {

  _norm = sqrt(pow(event->GetOrbitalInfo()->q0,2)+pow(event->GetOrbitalInfo()->q1,2)+pow(event->GetOrbitalInfo()->q2,2)+pow(event->GetOrbitalInfo()->q3,2));

  if (_norm < 0.9999 || _norm > 1.0001) {
    return 0;
  }

  if (event->GetOrbitalInfo()->timeGap > _timeGapMax) {
    return 0;
  }

  return CUTOK;
}
