/*
 * GeoFieldCut.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file GeoFieldCut.cpp The GeoFieldCut class implementation file */

#include "GeoFieldCut.h"

int GeoFieldCut::Check(PamLevel2 *event) {

  Float_t bAbs = event->GetOrbitalInfo()->Babs;
  if (bAbs < _bAbsMin) // Babs = absolute value of geomagnetic field (Gauss)
    return 0;
  if (_bAbsMax > _bAbsMin && bAbs > _bAbsMax)
    return 0;

  //cout << bAbs << endl;
  return CUTOK;
}
