/*
 * EvRateS11Cut.cpp
 *
 *  Created on: 21-mag-2009
 *      Author: Nicola Mori
 */

/*! @file EvRateS11Cut.cpp The EvRateS11Cut class implementation file. */

#include "EvRateS11Cut.h"

int EvRateS11Cut::Check(PamLevel2 *event) {

  float rate = 0.;
  for (int i = 0; i < 16; i++)
    rate += (float)event->GetTrigLevel2()->pmtcount1[i];
  rate /= 16.;
  if (rate > _maxRate || rate < _minRate)
    return 0;

  return CUTOK;
}
