/*
 * EvRateS11Cut.h
 *
 *  Created on: 21-mag-2009
 *      Author: Nicola Mori
 */

/*! @file EvRateS11Cut.h The EvRateS11Cut class declaration file. */

#ifndef EVRATES11CUT_H_
#define EVRATES11CUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief Cut on event rate on S11
 *
 * This cut discards those events recorded when the event rate on S11 was
 * outside a certain range.
 */
class EvRateS11Cut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * Default values for the rates are chosen to reject none of the events.
   *
   * @param cutName The cut's name.
   * @param maxRate The maximum rate.
   * @param minRate The minimum rate.
   */
  EvRateS11Cut(const char *cutName, float maxRate = 1e06, float minRate = 0.) :
    PamCut(cutName), _maxRate(maxRate), _minRate(minRate) {
  }
  /*! @brief Destructor. */
  ~EvRateS11Cut() {
  }

  /*! @brief The event rate check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if event rate on S11 is between minRate and maxRate.
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:
  float _maxRate, _minRate;

};
#endif /* EVRATES11CUT_H_ */

