/*
 * DataQualCut.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file DataQualCut.cpp The DataQualCut class implementation file */

#include "DataQualCut.h"

int DataQualCut::Check(PamLevel2 *event){

  //cout << "DataQualCut::Check: ";
  // ++++++++++ TRK ++++++++++

  if ((_cutMask & TRK) == TRK) {
    if (event->GetTrkLevel2()) {
      for (Int_t i=0; i<12; i++) { // check done for each DSP    
        if (!event->GetTrkLevel2()->StatusCheck(i,0x12)) { // decode error OR CRC error
          return TRK;
        }
      }
    }
    else {
      return TRK;
    }
  }
  //cout << "TRK ";
  
  // ++++++++++ CALO LEVEL 2++++++++++
  if ((_cutMask & CALO) == CALO) {
    if (event->GetCaloLevel2()) {
      if (!event->GetCaloLevel2()->IsGood(true)) {
        return CALO;
      }
    }
    else {
      return CALO;
    }
  }
  //cout << "CALO ";

  // ++++++++++ CALO LEVEL 1++++++++++
  if ((_cutMask & CALO_L1) == CALO_L1) {
    if (! (event->GetCaloLevel1() ) ) {
      return CALO;
    }
  }
  
  // ++++++++++ TOF ++++++++++
  if ((_cutMask & TOF) == TOF) {
    if (event->GetToFLevel2()) {
      if (event->GetToFLevel2()->unpackError) { // "unpackerror" here means "unpackerror !=0"
        return TOF;
      }
    }
    else {
      return TOF;
    }
  }
  //cout << "TOF ";
  
  // ++++++++++ AC ++++++++++
  if ((_cutMask & AC) == AC) {
    if (event->GetAcLevel2()) {
      if (event->GetAcLevel2()->unpackError || ((event->GetAcLevel2()->status[0] >> 2) & 1)
          || ((event->GetAcLevel2()->status[1] >> 2) & 1)) {
        return AC;
      }
    }
    else {
      return AC;
    }
  }
  //cout << "AC ";
  
  // ++++++++++ TRIG ++++++++++
  if ((_cutMask & TRIG) == TRIG) {
    if (event->GetTrigLevel2()) {
      if (event->GetTrigLevel2()->unpackError) {
        return TRIG;
      }
    }
    else {
      return TRIG;
    }
  }
  //cout << "TRIG ";
  
  //TODO: vedere se si puo' controllare anche l'unpack error per ORB (sembra  di no...)
  // ++++++++++ ORB ++++++++++
  if ((_cutMask & ORB) == ORB) {
    if (!event->GetOrbitalInfo()) {
      return ORB;
    }
  }
  //cout << "ORB";
  //cout << endl;
  
  return CUTOK;
}
