/*
 * AbsTimeCut.cpp
 *
 *  Created on: 22-mag-2009
 *      Author: Nicola Mori
 */

/*! @file AbsTimeCut.cpp The AbsTimeCut class implementation file */

#include "AbsTimeCut.h"

int AbsTimeCut::Check(PamLevel2 *event) {

  _time.Set(event->GetOrbitalInfo()->absTime, kFALSE, 0, kFALSE);
  // TTimestamp::GetDate() returns date in format YYYYMMDD so to compare it
  // with 6-digits dates we must subtract 20000000
  unsigned int date = _time.GetDate(kFALSE) - 20000000;
  unsigned int time = _time.GetTime(kFALSE);

  if (date < _initDate)
    return ABSTIMECUT_TOOEARLY;
  if (date == _initDate && time < _initTime)
    return ABSTIMECUT_TOOEARLY;

  if (date > _endDate)
    return ABSTIMECUT_TOOLATE;
  if (date == _endDate && time > _endTime)
    return ABSTIMECUT_TOOLATE;

  return CUTOK;
}
