/*
 * MiscCuts.h
 *
 *  Created on: 15-mag-2009
 *      Author: Nicola Mori
 */

#ifndef MISCCUTS_H_
#define MISCCUTS_H_

/*! @file MiscCuts.h This header contains the inclusion of all miscellaneous cuts. */

#include "AbsTimeCut/AbsTimeCut.h"           // Absolute time
#include "DataQualCut/DataQualCut.h"         // Data quality
#include "EvRateS11Cut/EvRateS11Cut.h"       // Event rate on S11
#include "GeoFieldCut/GeoFieldCut.h"         // Geomagnetic field cut
#include "InclInfoQualCut/InclInfoQualCut.h" // Inclination info quality
#include "LShellCut/LShellCut.h"             // L-Shell
#include "LTGeoFillCut/LTGeoFillCut.h"       // LT histo fill (binned in critical rigidity)
#include "LTQualCut/LTQualCut.h"             // Live Time
#include "OBTPktNumCut/OBTPktNumCut.h"       // OBT and packet number
#include "OBTQualCut/OBTQualCut.h"           // On Board Time
#include "PitchAngleCut/PitchAngleCut.h"     // Pitch angle
#include "PktQualCut/PktQualCut.h"           // Packet number
#include "StoermerCut/StoermerCut.h"         // Stoermer cutoff
#include "TrackRedGeomCut/TrackRedGeomCut.h" // Track contained in a rectangular pipe
#include "TrgConfCut/TrgConfCut.h"           // Trigger configuration

#endif /* MISCCUTS_H_ */
