/*
 * LTQualCut.cpp
 *
 *  Created on: 10-mar-2009
 *     Authors: Sergio Ricciarini, Nicola Mori
 */

/*! @file LTQualCut.cpp The LTQualCut class implementation file */

#include "LTQualCut.h"

int LTQualCut::Check(PamLevel2 *event) {
  // NOTE: run_id is not generally increasing with time.

  if (event->GetRunInfo()->ID != _previousRun) {
    _previousRun = event->GetRunInfo()->ID;
    _LT = -1.;
    return LT_NEWRUN;
  }

  _LT = 0.16 * (float) (event->GetTrigLevel2()->dltime[0]); // this gives LT in ms

  if (_LT < 0. || _LT >= _timeout) {
    return LT_INVALID;
  }

  return CUTOK;
}
