/*
 * OBTPktNumCut.h
 *
 *  Created on: 18/mar/2010
 *      Author: Nicola Mori
 */

#ifndef OBTPKTNUMCUT_H_
#define OBTPKTNUMCUT_H_

#include "../../../PamCut/PamCutBase/PamCutBase.h"

/*! @brief Event selection by OBT and packet number.
 *
 * A list of OBT and packet number couples is checked. Events are discarded if their
 * OBT and PktNum does not match any entry of the list.
 * */
class OBTPktNumCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * The list parameter define the events to be selected.
   *
   * @param cutName The cut's name.
   * @param list A list of (OBT, PktNum) pairs.
   * @param verbose If true, a message will be print to std output when an event is found. This can be useful
   *                when searching for rare events in many files, to identify which file contains the event
   *                by parsing std output. See #OBTPktNumCut.cpp for the current implementation of this message.
   */
  OBTPktNumCut(const char *cutName, vector<pair<unsigned int, unsigned int> > &list, bool verbose = false);

  /*! @brief Constructor.
   *
   * The OBT and PktNum are stored in a text file given by listFileName. The file must contain two
   * columns of numbers, each row containing the event OBT as first entry and the event PktNum as
   * second.
   *
   * @param cutName The cut's name.
   * @param listFileName The file containing the (OBT, PktNum) pairs.
   */
  OBTPktNumCut(const char *cutName, TString listFileName);

  /*! @brief Destructor. */
  ~OBTPktNumCut() {
  }

  /*! @brief The OBT and packet number check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the event's OBT and PktNum match one of the pairs specified to the constructor.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

  const vector<pair<unsigned int, unsigned int> > &GetList(){
    return _list;
  }

private:

  vector<pair<unsigned int, unsigned int> > _list;
  bool _verbose;
};
#endif /* OBTPKTNUMCUT_H_ */
