/*
 * OBTQualCut.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file OBTQualCut.cpp The OBTQualCut class implementation file */

#include "OBTQualCut.h"

int OBTQualCut::Check(PamLevel2 *event){

  // Check first event; TO BE CHANGED BACK
  if (_previousRun==numeric_limits<UInt_t>::max()) {
    _previousRun = event->GetRunInfo()->ID;
    _previousOBT = event->GetOrbitalInfo()->OBT;
    return OBT_INVALID;
  }

  // Check run
  if (event->GetRunInfo()->ID != _previousRun){ // overwrite info on previous run and OBT
    _previousRun = event->GetRunInfo()->ID;
    _previousOBT = event->GetOrbitalInfo()->OBT;
//    return OBT_NEWRUN; TO BE CHANGED BACK
	return CUTOK;
  }

  // the run is the same as the previous event: check OBT

  // Check OBT
  if (event->GetOrbitalInfo()->OBT <= _previousOBT){ // invalid OBT: do not overwrite info on previous run and OBT
    return OBT_INVALID;
  }

  // The OBT is good: overwrite info on previous OBT
  _previousOBT = event->GetOrbitalInfo()->OBT;
  return CUTOK;

}
