/*
 * InclInfoQualCut.h
 *
 *  Created on: 27-marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file InclInfoQualCut.h The InclInfoQualCut class definition file */

#ifndef INCLINFOQUALCUT_H_
#define INCLINFOQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The inclination info data quality cut: rejects events with norm of quaternions
 *         is not inside corridor 0.999 - 1.0001 and Time Gap betwean nearest real (not interpolated) 
 *	    quaternions more than an upper threshold.
 */
class InclInfoQualCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param TimeGapMax The maximum time gap accepted value in sec. It is value between nearesr not interpolated
   *                  quaternions, default value is 300 seconds.
   */
  InclInfoQualCut(const char* cutName, float timeGapMax = 300) :
    PamCut(cutName), _norm(-1.), _timeGapMax(timeGapMax) {
  }
  /*! @brief Destructor. */
  ~InclInfoQualCut() {
  }

  /*! @brief The inclination info quality check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if TimeGap <= TimeGapMax and norm of quaternions lies inside a corridor 0.999 - 1.0001
   */
  int Check(PamLevel2 *event);

private:
  float _norm;
  float _timeGapMax;
};

#endif /* INCLINFOQUALCUT_H_ */
