/*
 * DataQualCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: N. Mori, S. Ricciarini, E. Mocchiutti
 */

#ifndef DATAQUALCUT_H_
#define DATAQUALCUT_H_

/*! @file DataQualCut.h The DataQualCut class definition file */

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The event and data quality cut.
 * This cut ensures that all the data relative to the various detectors is
 * present in the current event and that it has been correctly read.
 */
//TODO: vedere se includere il ND e S4, chiedere riguardo al controllo su ORB che non c'e' in PamLevel2::IsGood()
class DataQualCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param cutMask An integer whose binary code would provide a mask for the cuts to apply;
   *        use a DETECTORCODE or a combination of them to enable the corresponding checks.
   *        Default: DEFAULT (meaning Level-2 for TRK, CALO, TOF, ANT, TRG, ORB).
   */

  DataQualCut(const char *cutName, unsigned int cutMask = DEFAULT) :
      PamCut(cutName), _cutMask(cutMask) {
  }
  /*! @brief Destructor. */
  ~DataQualCut() {
  }

  /*! @brief The event and data quality check.
   *
   * This method checks if the pointers to the various detectors level 2 data are present and
   * if the data has been correctly unpacked. If it finds missing or corrupted data, it
   * will stop the check and return a code corresponding to the missing/corrupted detector data.
   *
   * @param event The event to analyze.
   * @return #CUTOK if all the checked data are present and not corrupted.
   * @return #TRK if Tracker data is missing or corrupted.
   * @return #CALO if Calo level2 data is missing or corrupted.
   * @return #CALO_L1 if Calo level1 data is missing
   * @return #TOF if ToF data is missing or corrupted.
   * @return #ANT if AC data is missing or corrupted.
   * @return #TRG if Trigger data is missing or corrupted.
   * @return #ORB if Orbital Info data is missing.
   */
  int Check(PamLevel2 *event);

private:

  unsigned int _cutMask;
  Bool_t CL1IsGood(CaloLevel1 *cl1, CaloLevel2 *cl2); ///< Check CaloLevel1 Consistency

};
#endif /* DATAQUALCUT_H_ */
