/*
 * AbsTimeCut.h
 *
 *  Created on: 22-mag-2009
 *      Author: Nicola Mori
 */

/*! @file AbsTimeCut.h The AbsTimeCut class declaration file */

#ifndef ABSTIMECUT_H_
#define ABSTIMECUT_H_

#include "../../PamCutBase/PamCutBase.h"
#include <TTimeStamp.h>

/*! @enum AbsTimeCut_Return Return values for events discarded by AbsTimeCut. */
enum AbsTimeCut_Return {
  ABSTIMECUT_TOOEARLY, ///< The event happened before the time interval.
  ABSTIMECUT_TOOLATE
///< The event happened after the time interval.
};

/*! @brief A cut on absolute time.
 *
 * This selection rejects all events recorded outside a certain time interval.
 */
class AbsTimeCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * The parameters define the time interval. They have to be encoded as 6-digits numbers,
   * eg.: 18 March 2008 15:30:00 will be encoded as 080318 for the date and as 153000 for the time.
   *
   * @param cutName The cut's name
   * @param initDate The initial date (format: YYMMDD).
   * @param initTime The initial time (format: hhmmss).
   * @param endDate The final date (format: YYMMDD);.
   * @param endTime The final time (format: hhmmss).
   */
  AbsTimeCut(const char *cutName, const char *initDate, const char * initTime, const char * endDate,
      const char * endTime) :
    PamCut(cutName), _initDate(atoi(initDate)), _initTime(atoi(initTime)), _endDate(atoi(endDate)), _endTime(atoi(
        endTime)), _time() {
  }

  /*! @brief Destructor. */
  ~AbsTimeCut() {
  }

  /*! @brief The absolute time check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the event happened inside the time interval
   * @return #ABSTIMECUT_TOOEARLY if the event happened before the begin of the time interval.
   * @return #ABSTIMECUT_TOOLATE if the event happened after the end of the time interval.
   */
  int Check(PamLevel2 *event);

private:

  unsigned int _initDate, _initTime, _endDate, _endTime;
  TTimeStamp _time;
};
#endif /* ABSTIMECUT_H_ */
