/*
 * VerboseBlindCollection.h
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file VerboseBlindCollection.h The VerboseBlindCollection class definition file */

#ifndef VERBOSEBLINDCOLLECTION_H_
#define VERBOSEBLINDCOLLECTION_H_

#include "../SmartBlindCollection/SmartBlindCollection.h"
/*! @brief A smart blind collection which prints selection reports.
 *
 * This class inherits from SmartBlindCollection, so it can handle actions. It is designed to
 * automate a very common task: printing the selection results at the end of the analysis.
 * Other desired tasks can be accomplished by means of actions.
 */
class VerboseBlindCollection: public SmartBlindCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  VerboseBlindCollection(const char *collectionName, bool owns = true) :
    SmartBlindCollection(collectionName, owns) {
  }

  /*! @brief Destructor. */
  ~VerboseBlindCollection() {
  }

  /*! @brief The post analysis task.
   *
   * This implementation simply prints the selection report, and then calls
   * SmartColletion::Finalize().
   */
  void Finalize();

};

#endif /* VERBOSEBLINDCOLLECTION_H_ */
