/*
 * SmartCollection.cpp
 *
 *  Created on: 14-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SmartCollection.cpp The SmartCollection class implementation file */

#include "SmartCollection.h"

SmartCollection::~SmartCollection() {
  if (_owns) {
    for (unsigned int i = 0; i < _actions.size(); i++)
      if (_actions[i] != NULL) {
        delete _actions[i];
        _actions[i] = NULL;
      }
  }
}

void SmartCollection::AddAction(CollectionAction *action) {
  _actions.push_back(action);
  _actionsPositions.push_back(GetSize() - 1);
}

CollectionAction *SmartCollection::GetAction(unsigned int iAction) {
  if (_actions.size() == 0)
    return NULL;
  if (iAction < 0 || iAction > _actions.size() - 1)
    return NULL;
  else
    return _actions[iAction];
}

CollectionAction *SmartCollection::GetAction(const char *actionName) {
  if (_actions.size() == 0)
    return NULL;
  for (unsigned int i = 0; i < _actions.size(); i++) {
    if (strcmp(_actions[i]->GetName(), actionName) == 0)
      return _actions[i];
  }

  return NULL;
}

void SmartCollection::Setup(PamLevel2 *events) {
  PamCutCollection::Setup(events);
  //cout << GetName() << endl;

  for (unsigned int i = 0; i < _actions.size(); i++) {
    _actions[i]->Setup(events);
  }
}

void SmartCollection::Finalize() {
  PamCutCollection::Finalize();

  for (unsigned int i = 0; i < _actions.size(); i++) {
    _actions[i]->Finalize();
  }
}

int SmartCollection::ApplyCut(PamLevel2 *event) {

  _nEv++;

  // Execute the actions placed before the cuts
  unsigned int iBeforeCuts = 0;
  //cout << GetName() << endl;
  if (_actions.size() > 0) {
    while (_actionsPositions[iBeforeCuts] == -1) {
      _actions[iBeforeCuts]->OnGood(event);
      iBeforeCuts++;
      if (iBeforeCuts == _actions.size())
        break;
    }
  }

  // Apply the cuts
  if (_cuts.size() == 0) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }

  unsigned int firstFailed = _cuts.size();
  unsigned int iAction = iBeforeCuts;
  for (unsigned int iCut = 0; iCut < _cuts.size(); iCut++) {
    if (_cuts[iCut]->ApplyCut(event) != CUTOK && firstFailed == _cuts.size()) {
      firstFailed = iCut;
      // Apply the bad actions at the end of the bunch
      if (iAction < _actions.size()) {
        unsigned int lastPosition = _actionsPositions[iAction];
        for (; iAction < _actions.size(); iAction++) {
          if (_actionsPositions[iAction] > (int) lastPosition) // Don't do actions at the end of successive bunches
            break;
          _actions[iAction]->OnBad(event, (int) firstFailed);

        }
      }
      break;
    }
    else if (iAction < _actions.size()) {
      // Do the good actions if we are at the end of the bunch
      while (_actionsPositions[iAction] == (int) iCut) {
        _actions[iAction]->OnGood(event);
        iAction++;
        if (iAction == _actions.size())
          break;
      }
    }
  }

  if (firstFailed == _cuts.size()) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }
  else {
    OnBad(event, firstFailed);
    return firstFailed;
  }
}
