/*
 * SmartCollection.cpp
 *
 *  Created on: 14-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SmartCollection.cpp The SmartCollection class implementation file */

#include "SmartCollection.h"

void SmartCollection::AddAction(CollectionAction& action) {
  _actions.push_back(&action);
}

CollectionAction *SmartCollection::GetAction(unsigned int iAction) {
  if (_actions.size() == 0)
    return NULL;
  if (iAction < 0 || iAction > _actions.size() - 1)
    return NULL;
  else
    return _actions[iAction];
}

void SmartCollection::Setup(PamLevel2 *events){
  PamCutCollection::Setup(events);

  for (unsigned int i = 0; i < GetSize(); i++){
    _actions[i]->Setup(events);
  }
}

void SmartCollection::Finalize(){
  PamCutCollection::Finalize();

  for (unsigned int i = 0; i < GetSize(); i++){
    _actions[i]->Finalize();
  }
}

void SmartCollection::OnGood(PamLevel2 *event){
  PamCutCollection::OnGood(event);

  for (unsigned int i = 0; i < GetSize(); i++){
    _actions[i]->OnGood(event);
  }
}

void SmartCollection::OnBad(PamLevel2 *event, int selectionResult){
  PamCutCollection::OnBad(event, selectionResult);

  for (unsigned int i = 0; i < GetSize(); i++){
    _actions[i]->OnBad(event, selectionResult);
  }
}
