/*
 * SmartBlindCollection.cpp
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SmartCollection.cpp The SmartBlindCollection class implementation file */

#include "SmartBlindCollection.h"

int SmartBlindCollection::ApplyCut(PamLevel2 *event) {

  _nEv++;

  // Execute the actions placed before the cuts
  unsigned int iBeforeCuts = 0;
  //cout << GetName() << endl;
  if (_actions.size() > 0) {
    while (_actionsPositions[iBeforeCuts] == -1) {
      _actions[iBeforeCuts]->OnGood(event);
      iBeforeCuts++;
      if (iBeforeCuts == _actions.size())
        break;
    }
  }

  // Apply the cuts
  if (_cuts.size() == 0) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }

  unsigned int firstFailed = _cuts.size();
  unsigned int iAction = iBeforeCuts;
  for (unsigned int iCut = 0; iCut < _cuts.size(); iCut++) {
    if (_cuts[iCut]->ApplyCut(event) != CUTOK && firstFailed == _cuts.size()) {
      firstFailed = iCut;
    }

    if (iAction < _actions.size()) {
      if (firstFailed == _cuts.size()) { // No cut has failed yet
        while (_actionsPositions[iAction] == (int) iCut) {
          _actions[iAction]->OnGood(event);
          iAction++;
          if (iAction == _actions.size())
            break;
        }
      }
      else {
        while (_actionsPositions[iAction] == (int) iCut) {
          _actions[iAction]->OnBad(event, (int) firstFailed);
          iAction++;
          if (iAction == _actions.size())
            break;
        }
      }

    }
  }

  if (firstFailed == _cuts.size()) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }
  else {
    OnBad(event, firstFailed);
    return firstFailed;
  }

}
