/*
 * MaskedCollection.h
 *
 *  Created on: 19-apr-2011
 *      Author: Nicola Mori
 */

/*! @file MaskedCollection.h The MaskedCollection class definition file */

#ifndef MASKEDCOLLECTION_H_
#define MASKEDCOLLECTION_H_

#include "../../../PamCut/Collections/VerboseCollection/VerboseCollection.h"

/*! @brief A collection which can use inverse cuts.
 *
 * This collection allow to define a flag for each cut which inverts the result of the cut.
 * This can be useful to select events that does NOT fulfill some constraints.
 */
class MaskedCollection: public VerboseCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  MaskedCollection(const char *collectionName, bool owns = true) :
    VerboseCollection(collectionName, owns), _mask(0) {
  }

  /*! @brief Destructor. */
  ~MaskedCollection() {
  }

  /*! @brief Adds a cut.
   *
   * A cut added with this method will work as defined.
   * @param cut The pointer to a PamCut-derived object to add to the collection.
   */
  void AddCut(PamCut *cut);

  /*! @brief Adds an inverse cut.
   *
   * A cut added with this method will work in the inverse way: it will discard an event if
   * the event satisfy the cut's selection criteria.
   * @param cut The pointer to a PamCut-derived object to add to the collection.
   */
  void AddInverseCut(PamCut *cut);

  /*! @brief Applies the cuts to the event, taking into account the inversion mask.
   *
   * @param event The event to analyze.
   * @return CUTOK if the event satisfy each masked cut.
   */
  int ApplyCut(PamLevel2 *event);

private:
  vector<bool> _mask;

};

#endif /* MASKEDCOLLECTION_H_ */
