/*
 * EffBetaToRigCollection.h
 *
 *  Created on: 12/lug/2011
 *      Author: Nicola Mori
 */

/*! @file EffBetaToRigCollection.h The EffBetaToRigCollection class definition file. */

#ifndef EFFBETATORIGCOLLECTION_H_
#define EFFBETATORIGCOLLECTION_H_

#include "../BinnedEffCollection/BinnedEffCollection.h"

/*! @brief A rigidity-from-beta binned efficiency collection
 *
 * This class inherits from #BinnedEffCollection: it only implements the #GetBinValue method
 * to return event rigidity (with sign) as computed from beta standalone, assuming a certain mass and Z.
 */
class EffBetaToRigCollection: public BinnedEffCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name. The graph in the ROOT output will have the same name, so be
   *                       careful to name the collection respecting the C++ rules for the names of the variables
   *                       (eg. don't use - in the name) otherwise the graph will be unusable.
   * @param outFileBase The output file base name. It will produce the same file as the parent class #EffCollection
   *                    with the total efficiency, plus a similar file (named outFileBase + collection's name + "-rig.txt")
   *                    with a row for each rigidity bin. At the beginning of each row there will be two additional columns
   *                    with the edges of the bin. Additionally, a ROOT file (outFileBase + collection's name +"-rig.root")
   *                    will be produced, containing the efficiency graph.
   * @param rigBinsFile The file with the rigidity bins.
   * @param mass The particle's mass in GeV (default: proton mass).
   * @param charge The particle's charge (default: 1).
   * @param errMethod The method to use for error computation. Possible values are defined in #EffCollection_ErrMethod.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  EffBetaToRigCollection(const char *collectionName, TString outFileBase = "", TString rigBinsFile = "", float mass =
      H_MASS, float charge = 1, int errMethod = EFFERR_SERGIO, bool owns = true);

  /*! @brief Destructor. */
  ~EffBetaToRigCollection() {

  }

  /*! @brief The value of binning parameter (rigidity from beta).
   *
   * @param event The current event.
   * @return The rigidity (with sign) computed from beta standalone of current event.
   */
  float GetBinValue(PamLevel2 *event);

private:

  float _mass, _charge;
};

#endif /* EFFBETATORIGCOLLECTION_H_ */
