/*
 * EffBetaCollection.h
 *
 *  Created on: 20/jul/2011
 *      Author: Nicola Mori
 */

/*! @file EffBetaCollection.h The EffBetaCollection class definition file. */

#ifndef EFFBETACOLLECTION_H_
#define EFFBETACOLLECTION_H_

#include "../BinnedEffCollection/BinnedEffCollection.h"

/*! @brief A beta binned efficiency collection
 *
 * This class inherits from #BinnedEffCollection: it only implements the #GetBinValue method
 * to return event rigidity with sign.
 *
 */
class EffBetaCollection: public BinnedEffCollection {

public:

  /*! @brief Constructor.
   *
   * The parameter standAlone let the user choose which beta measurement use for binning. If standAlone == true,
   * beta[12] from TOF standAlone track will be used; otherwise, beta[12] from physical tracker's track is used.
   * Note that in the latter case a physical track must exist, so somewhere in the cut chain a #TrkPhSinCut must
   * be placed to ensure this condition.
   *
   * @param collectionName The collection's name. The graph in the ROOT output will have the same name, so be
   *                       careful to name the collection respecting the C++ rules for the names of the variables
   *                       (eg. don't use - in the name) otherwise the graph will be unusable.
   * @param outFileBase The output file base name. It will produce the same file as the parent class #EffCollection
   *                    with the total efficiency, plus a similar file (named outFileBase + collection's name + "-rig.txt")
   *                    with a row for each rigidity bin. At the beginning of each row there will be two additional columns
   *                    with the edges of the bin. Additionally, a ROOT file (outFileBase + collection's name +"-rig.root")
   *                    will be produced, containing the efficiency graph.
   * @param betaBinsFile The file with the beta bins.
   * @param standAlone If true, beta[12] standaone will be used; otherwise beta[12] from physical track.
   * @param errMethod The method to use for error computation. Possible values are defined in #EffCollection_ErrMethod.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  EffBetaCollection(const char *collectionName, TString outFileBase = "", TString betaBinsFile = "", bool standAlone =
      true, int errMethod = EFFERR_SERGIO, bool owns = true);

  /*! @brief Destructor. */
  ~EffBetaCollection() {

  }

  /*! @brief The value of binning parameter (beta).
   *
   * @param event The current event.
   * @return The beta of current event.
   */
  float GetBinValue(PamLevel2 *event);

private:

  bool _standAlone;
};

#endif /* EFFBETACOLLECTION_H_ */
