/*
 * EffBetaCollection.cpp
 *
 *  Created on: 20/jul/2011
 *      Author: Nicola Mori
 */

/*! @file EffBetaCollection.cpp The EffBetaCollection class implementation file. */

#include "EffBetaCollection.h"

EffBetaCollection::EffBetaCollection(const char *collectionName, TString outFileBase, TString rigBinsFile,
    bool standAlone, int errMethod, bool owns) :
    BinnedEffCollection(collectionName, outFileBase, rigBinsFile, errMethod, owns), _standAlone(standAlone) {
}

float EffBetaCollection::GetBinValue(PamLevel2 *event) {

  static int trkSeqNo;
  if (_standAlone)
    trkSeqNo = 0;
  else {
    for (int i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
      if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == event->GetTrack(0)->GetTrkTrack()->GetSeqNo())
        trkSeqNo = i;
    }
  }

  float beta = event->GetToFLevel2()->GetToFTrkVar(trkSeqNo)->beta[12];

  return beta;
}
