/*
 * BlindCutCollection.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file BlindCutCollection.h The BlindCutCollection class definition file */

#ifndef BLINDCUTCOLLECTION_H_
#define BLINDCUTCOLLECTION_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief A cut collection which applies all the cuts.
 *
 * This cut collection will apply all the cuts it contains to the
 * events, even if some of them are not satisfied.
 */
class BlindCutCollection: public PamCutCollection {
public:
  /*! @brief Constructor. */
  BlindCutCollection(const char *cutName): PamCutCollection(cutName){
  }

  /*! @brief Destructor. */
  ~BlindCutCollection() {
  }

  /*! @brief Checks all the cuts.
   *
   *  This method checks all the cuts for the current event. It exits only after
   *  all the cuts have been evaluated. Note that it doesn't call OnGood() nor OnBad(), not
   *  even for the PamCut objects in the collection.
   *  @return the index of the first failed cut (range: [0, \#cuts-1], see AddCut()); \
   *          #CUTOK if the event satisfies all the cuts.
   */
  int Check(PamLevel2 *event);

  /*! @brief Applies all the cuts to the current event.
   *
   *  This routine works pretty much like the redefinition of Check(), calling ApplyCut() (instead of
   *  Check() )for each cut. However, if a cut fails, it does not stops but continues until all the
   *  cuts are evaluated. If all the cuts are successful, on exit it calls OnGood(); if a single cut
   *  failed, it calls OnBad(), passing the index of the first failed cut as selectionResult.
   *
   * @param event The event to analyze.
   * @return same return values as Check().
   */
  int ApplyCut(PamLevel2 *event);
  //void OnGood(PamLevel2 *event){cout << "BlindCutCollection::OnGood" << endl;}
  //void OnBad(PamLevel2 *event, int selectionResult){cout << "BlndCutCollection::OnBad, SelectionResult=" << selectionResult << endl;}

};



#endif /* BLINDCUTCOLLECTION_H_ */
