/*
 * BlindCutCollection.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file BlindCutCollection.cpp The BlindCutCollection class implementation file */

#include "BlindCutCollection.h"

int BlindCutCollection::Check(PamLevel2 *event){

  if (_cuts.size() == 0) {
    return CUTOK;
  }

  int firstFailed = CUTOK;
  for (unsigned int icut = 0; icut < _cuts.size(); icut++) {
    if (_cuts[icut]->Check(event) != CUTOK && firstFailed == CUTOK) {
      firstFailed = icut;
    }
  }

  return firstFailed;

}

int BlindCutCollection::ApplyCut(PamLevel2 *event) {

  _nEv++;
  if (_cuts.size() == 0) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }

  int firstFailed = CUTOK;
  for (unsigned int icut = 0; icut < _cuts.size(); icut++) {
    if (_cuts[icut]->ApplyCut(event) != CUTOK && firstFailed == CUTOK) {
      firstFailed = icut;
    }
  }

  if (firstFailed == CUTOK) {
    _nGood++;
    OnGood(event);
  }
  else {
    OnBad(event, firstFailed);
  }
  return firstFailed;
}
