/*
 * SmartBlindCollection.h
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SmartBlindCollection.h The SmartBlindCollection class definition file */

#ifndef SMARTBLINDCOLLECTION_H_
#define SMARTBLINDCOLLECTION_H_

#include "../SmartCollection/SmartCollection.h"

/*! @brief A blind collection class designed to use CollectionAction objects.
 *
 * The SmartBlindCollection class is designed to handle CollectionAction objects. These
 * defines the procedures to do when an event is selected or discarded.
 * This collection differs from SmartCollection only because it is blind, ie., it will apply
 * all the cuts to each events, even if some of them fail (see #BlindCutCollection to get
 * more info about blind collections). In current implementation, after a cut has failed, it
 * will call OnBad for all the actions that come after that cut (also the ones at the end of
 * successive bunches), regardless if, for example, in a certain subsequent bunch all the
 * cuts are satisfied.
 */
class SmartBlindCollection: public SmartCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  SmartBlindCollection(const char* collectionName, bool owns = true) :
    SmartCollection(collectionName, owns) {
  }

  /*! @brief Destructor. */
  ~SmartBlindCollection() {
  }

  /*! Applies the cuts and executes the actions.
   *
   * When cuts are applied, a SmartBlindCollection will also execute the actions at the end
   * of the bunches of cuts.
   *
   * @param event The event to analyze.
   */
  int ApplyCut(PamLevel2 *event);
};

#endif /* SMARTBLINDCOLLECTION_H_ */
