/*
 * VerboseCollection.cpp
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file VerboseCollection.cpp The VerboseCollection class implementation file */

#include "VerboseCollection.h"
#include <cmath>

void VerboseCollection::Finalize() {

  // Prepare the output format
  streamsize oldPrec = cout.precision();
  streamsize newPrec = 4;
  cout.precision(newPrec);
  cout.setf(ios::fixed, ios::floatfield);
  unsigned int nDigitsEvents = 0;
  double nEvents = (double) GetNEv();
  while (nEvents >= 1.) {
    nEvents /= 10.;
    nDigitsEvents++;
  }
  unsigned int nameWidth = 0;

  for (unsigned int i = 0; i < _cuts.size(); i++) {
    if (strlen(GetCut(i)->GetName()) > nameWidth)
      nameWidth = strlen(GetCut(i)->GetName());
  }

  cout << "\n- Collection: " << GetName() << "\n";
  cout << "  Selected/Analized events (eff.): " << GetNGood() << "/" << GetNEv() << "  (" << (float) GetNGood()
      / (float) GetNEv() << ")\n";
  cout << "     " << setw(nameWidth + 1) << "--Single cuts--";
  cout << "     " << setw(nDigitsEvents) << "sel.";
  cout << "     " << setw(nDigitsEvents) << "tot.";
  cout << "     " << setw(newPrec + 2) << "eff.";
  cout << "     " << setw(newPrec + 2) << "prog. eff.\n";
  for (unsigned int i = 0; i < GetSize(); i++) {
    cout << "     " << setw(nameWidth) << GetCut(i)->GetName() << ":";
    cout << "     " << setw(nDigitsEvents) << GetCut(i)->GetNGood();
    cout << "     " << setw(nDigitsEvents) << GetCut(i)->GetNEv();
    cout << "     " << (float) GetCut(i)->GetNGood() / (float) GetCut(i)->GetNEv();
    cout << "     " << (float) GetCut(i)->GetNGood() / (float) GetNEv();
    cout << "\n";

  }
  cout << endl;

  // Reset the output format
  cout.precision(oldPrec);
  cout << resetiosflags(ios::floatfield);

  SmartCollection::Finalize();

}
