/*
 * SmartBlindCollection.cpp
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file SmartCollection.cpp The SmartBlindCollection class implementation file */

#include "SmartBlindCollection.h"

int SmartBlindCollection::ApplyCut(PamLevel2 *event) {

  _nEv++;
  if (_cuts.size() == 0) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }

  unsigned int firstFailed = _cuts.size();
  for (unsigned int icut = 0; icut < _cuts.size(); icut++) {
    if (_cuts[icut]->ApplyCut(event) != CUTOK && firstFailed == _cuts.size()) {
      firstFailed = icut;
    }
  }

  //Do actions
  if (_actions.size() > 0) {
    for (unsigned int i = 0; i < _actions.size(); i++) {
      if (_actionsPositions[i] < (int)firstFailed)
        _actions[i]->OnGood(event);
      else
        _actions[i]->OnBad(event, firstFailed);
    }
  }

  if (firstFailed == _cuts.size()) {
    _nGood++;
    OnGood(event);
    return CUTOK;
  }
  else {
    OnBad(event, firstFailed);
    return firstFailed;
  }

}
