/*
 * TrkChi2VsDeflHistoAction.cpp
 *
 *  Created on: 14/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TrkChi2VsDeflHistoAction.cpp The TrkChi2VsDeflHistoAction class implementation file. */

#include "TrkChi2VsDeflHistoAction.h"

TrkChi2VsDeflHistoAction::TrkChi2VsDeflHistoAction(const char *actionName, TString outFileName, TString mode,
    bool logChi2, float minDefl, float maxDefl, unsigned int nBinsDefl, float minChi2, float maxChi2,
    unsigned int nBinsChi2) :
  CollectionAction(actionName), _outFileName(outFileName), _histo(), _histoX(0), _histoY(0), _mode(mode), _logChi2(
      logChi2), _cout_sbuf(cout.rdbuf()), _fout("/dev/null"){

  double deflBins[nBinsDefl + 1];
  double maxExp = log10(maxDefl / minDefl);
  for (unsigned int i = 0; i < nBinsDefl + 1; i++) {
    deflBins[i] = minDefl * pow(10., (double) i / ((double) nBinsDefl) * maxExp);
  }

  double chi2Bins[nBinsChi2 + 1];
  if (_logChi2) {
    //LINEAR scale for log10(chi2) values
    double chi2Step = (log10(maxChi2 / minChi2)) / (double) nBinsChi2;
    minChi2 = log10(minChi2);
    for (unsigned int i = 0; i < nBinsChi2 + 1; i++) {
      chi2Bins[i] = minChi2 + i * chi2Step;
    }
  }
  else {
    //LOG scale for chi2 values
    maxExp = log10(maxChi2 / minChi2);
    for (unsigned int i = 0; i < nBinsChi2 + 1; i++) {
      chi2Bins[i] = minChi2 * pow(10., (double) i / ((double) nBinsChi2) * maxExp);
    }
  }
  _histo.SetBins(nBinsDefl, deflBins, nBinsChi2, chi2Bins);

  // Set labels
  _histo.SetName(GetName());
  _histoX = (TH2F*) _histo.Clone(TString(GetName()) + TString("_X"));
  _histoY = (TH2F*) _histo.Clone(TString(GetName()) + TString("_Y"));
  if (_logChi2) {
    _histo.SetTitle("Trk log10(Chi2) Vs Deflection");
    _histo.GetYaxis()->SetTitle("log10(Chi2)");
    _histoX->SetTitle("Trk log10(Chi2 X) Vs Deflection");
    _histoX->GetYaxis()->SetTitle("log10(Chi2 X)");
    _histoY->SetTitle("Trk log10(Chi2 Y) Vs Deflection");
    _histoY->GetYaxis()->SetTitle("log10(Chi2 Y)");
  }
  else {
    _histo.SetTitle("Trk Chi2 Vs Deflection");
    _histo.GetYaxis()->SetTitle("Chi2");
    _histoX->SetTitle("Trk Chi2 X Vs Deflection");
    _histoX->GetYaxis()->SetTitle("Chi2 X");
    _histoY->SetTitle("Trk Chi2 Y Vs Deflection");
    _histoY->GetYaxis()->SetTitle("Chi2 Y");
  }

  //_histo.SetBins(nBinsDefl, minDefl, maxDefl, nBinsChi2, minChi2, maxChi2);


}

void TrkChi2VsDeflHistoAction::OnGood(PamLevel2 *event) {

  cout.rdbuf(_fout.rdbuf());

  if (_logChi2) {
    if (event->GetTrack(0)->GetTrkTrack()->chi2 > 0.) {
      _histo.Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), log10(event->GetTrack(0)->GetTrkTrack()->chi2));
      _histoX->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), log10(
          event->GetTrack(0)->GetTrkTrack()->GetChi2X()));
      _histoY->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), log10(
          event->GetTrack(0)->GetTrkTrack()->GetChi2Y()));
    }
  }
  else {
    _histo.Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), event->GetTrack(0)->GetTrkTrack()->chi2);
    _histoX->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), event->GetTrack(0)->GetTrkTrack()->GetChi2X());
    _histoY->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), event->GetTrack(0)->GetTrkTrack()->GetChi2Y());
  }

  cout.rdbuf(_cout_sbuf);
}
void TrkChi2VsDeflHistoAction::Finalize() {

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _histo.Write();
  _histoX->Write();
  _histoY->Write();
  outFile.Close();
}
