/*
 * TreeOutputAction.cpp
 *
 *  Created on: 03/nov/2009
 *      Author: Nicola Mori
 */

#include "TreeOutputAction.h"

TreeOutputAction::TreeOutputAction(const char *actionName, TString outFileName) :
  CollectionAction(actionName), _outFileName(outFileName) {
}

TreeOutputAction::~TreeOutputAction() {
  _outFile->Close();
  delete _outFile;
  _outFile = NULL;
}

void TreeOutputAction::Setup(PamLevel2 *events) {

  _outFile = new TFile(_outFileName, "RECREATE");
  _InitBranches(events);

}

void TreeOutputAction::OnGood(PamLevel2 *event) {

  _ComputeBranches(event);
  _outFile->cd();
  _tree->Fill();

}

void TreeOutputAction::Finalize() {

  _outFile->cd();
  _tree->Write();

}
