/*
 * ZenVsAzAngleHistoAction.h
 *
 *  Created on: 28-marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file ZenVsAzAngleHistoAction.h The ZenVsAzAngleHistoAction class declaration file. */

#include "../Histo2DAction/Histo2DAction.h"

#ifndef ZENVSAZANGLEHISTOACTION_H_
#define ZENVSAZANGLEHISTOACTION_H_

/*! @brief An action that fills a zenith-angle Vs azimuth-angle of incoming particle histogram.
 *
 */
class ZenVsAzAngleHistoAction: public Histo2DAction<Int_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  ZenVsAzAngleHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot =
      true, bool outText = true, TString title = "Zenith Vs. Azimuth angles");

  /*! @brief Destructor. */
  ~ZenVsAzAngleHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};
#endif /* ZENVSAZANGLEHISTOACTION_H_ */
