/*
 * ZenVsAzAngleHistoAction.cpp
 *
 *  Created on: 28-marth-2010
 *      Author: Vitaly Malakhov
 */

/*! @file ZenVsAzAngleHistoAction.cpp The ZenVsAzAbnleHistoAction class implementation file. */

#include "ZenVsAzAngleHistoAction.h"
#include "TMath.h"

ZenVsAzAngleHistoAction::ZenVsAzAngleHistoAction(const char *actionName, TString outFileBase, TString mode,
    bool outRoot, bool outText, TString title) :
    Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText){

}

void ZenVsAzAngleHistoAction::OnGood(PamLevel2 *event) {
    PamTrack *track;
    track = event->GetTrack(0);
    Float_t Aaxv = TMath::Abs(track->GetTrkTrack()->axv[0])*TMath::DegToRad();
    Float_t Aayv = TMath::Abs(track->GetTrkTrack()->ayv[0])*TMath::DegToRad();
    Float_t PamZenith = TMath::RadToDeg()*asin(sqrt(pow(sin(Aayv), 2) + pow(sin(Aaxv), 2)));

    Float_t axv = -track->GetTrkTrack()->axv[0] * TMath::DegToRad();
    Float_t ayv = -track->GetTrkTrack()->ayv[0] * TMath::DegToRad();
    Float_t angle = atan(sin(TMath::Abs(ayv))/sin(TMath::Abs(axv))) * TMath::RadToDeg();

    Float_t PamAzim =  360. - angle;
    if(axv>=0 && ayv >=0) PamAzim = angle;
    if(axv<0 && ayv >0) PamAzim = 180. - angle;
    if(axv<0 && ayv <0) PamAzim = 180. + angle;

    PamAzim = PamAzim * TMath::DegToRad();
    PamZenith = (180 - PamZenith) * TMath::DegToRad();

    Fill(TMath::RadToDeg()*PamAzim, TMath::RadToDeg()*PamZenith);
}
