/*
 * TrkYVsXHistoAction.cpp
 *
 *  Created on: 02/dec/2009
 *      Author: Sergio Ricciarini
 */

/*! @file TrkYVsXHistoAction.cpp The TrkYVsXHistoAction class implementation file. */

#include "TrkYVsXHistoAction.h"

TrkYVsXHistoAction::TrkYVsXHistoAction(const char *actionName, TString outFileBase, TString mode,
    bool outRoot, bool outText, TString title, UInt_t igf) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText), _igf(igf) {

  SetXAxis("X (cm)",100,TrkParams::xGF_min[_igf],TrkParams::xGF_max[_igf]); // Default X axis
  SetYAxis("Y (cm)",100,TrkParams::yGF_min[_igf],TrkParams::yGF_max[_igf]); // Default Y axis
  
}

void TrkYVsXHistoAction::OnGood(PamLevel2 *event) {

  Fill(event->GetTrack(0)->GetTrkTrack()->xGF[_igf],
    event->GetTrack(0)->GetTrkTrack()->yGF[_igf]);

}
