/*
 * TofBetaVsTrkRigHistoAction.h
 *
 *  Created on: 24/jun/2010
 *      Author: S. Ricciarini
 */

/*! @file TrkRigVsGPMomHistoAction.h The TrkRigVsGPMomHistoAction class declaration file. */

#ifndef TRKRIGVSGPMOMHISTOACTION_H_
#define TRKRIGVSGPMOMHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a Trk Rig (with sign, GV) vs. GPamela Momentum (GeV/c) histogram. */
class TrkRigVsGPMomHistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TrkRigVsGPMomHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot =
      true, bool outText = true, TString title = "TRK Rig (GV) vs. GP Mom (GeV/c)");

  /*! @brief Destructor */
  ~TrkRigVsGPMomHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);


};
#endif /* TRKRIGVSGPMOMHISTOACTION_H_ */
