/*
 * TrkDedxVsRigHistoAction.h
 *
 *  Created on: 9-giu-2009
 *      Author: Nicola Mori
 */

/*! @file TrkDedxVsRigHistoAction.h The TrkDedxVsRigHistoAction class declaration file. */

#include "../Histo2DAction/Histo2DAction.h"

#ifndef TRKDEDXVSRIGHISTOACTION_H_
#define TRKDEDXVSRIGHISTOACTION_H_

/*! @brief An action that fills a TRK dE/dx Vs rigidity histogram.
 *
 *  In current implementation, the rigidity of the event is taken as an absolute value.
 */
class TrkDedxVsRigHistoAction: public Histo2DAction<Int_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TrkDedxVsRigHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot =
      true, bool outText = true, TString title = "TRK dE/dx Vs. Rigidity");

  /*! @brief Destructor. */
  ~TrkDedxVsRigHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};
#endif /* TRKDEDXVSRIGHISTOACTION_H_ */
