/*
 * TrkDedxVsBetaHistoAction.h
 *
 *  Created on: 18-feb-2010
 *      Author: Nicola Mori
 */

/*! @file TrkDedxVsBetaHistoAction.h The TrkDedxVsBetaHistoAction class declaration file. */

#include "../Histo2DAction/Histo2DAction.h"

#ifndef TRKDEDXVSBETAHISTOACTION_H_
#define TRKDEDXVSBETAHISTOACTION_H_

/*! @enum WHICHBETA Aliases to select which beta to use in TrkDedxVsBetaHistoAction. */
enum WHICHBETA {
  BETA12, BETA12_STANDALONE, BETABEST, BETABEST_STANDALONE
};

/*! @brief An action that fills a TRK dE/dx Vs beta histogram.
 *
 *  beta can be recomputed by using the appropriate input parameters of the constructor
 */
class TrkDedxVsBetaHistoAction: public Histo2DAction<Int_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param whichBeta the beta to use. Actually BETA12 and BETABEST are supported.
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TrkDedxVsBetaHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", int whichBeta =
      BETA12, bool outRoot = true, bool outText = true,
      TString title = "TRK dE/dx Vs. #beta");

  /*! @brief Destructor. */
  ~TrkDedxVsBetaHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:

  int _whichBeta;

};
#endif /* TRKDEDXVSBETAHISTOACTION_H_ */
