/*
 * TrkDOFVsDeflHistoAction.h
 *
 *  Created on: 02/set/2009
 *      Author: Nicola Mori
 */

/*! @file TrkDOFVsDeflHistoAction.h The TrkDOFVsDeflHistoAction class declaration file. */

#ifndef TRKDOFVSDEFLHISTOACTION_H_
#define TRKDOFVSDEFLHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a \#DOF Vs. Deflection histogram.
 *
 * The number of degrees of freedom of an event is the number of clusters along the track
 * minus 5 (which is the number of parameters of the track).
 */
class TrkDOFVsDeflHistoAction: public Histo2DAction<Int_t> {

public:

   /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TrkDOFVsDeflHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE",
      bool outRoot = true, bool outText = true, TString title = "TRK DOF Vs. Rigidity");


  /*! @brief Destructor */
  ~TrkDOFVsDeflHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};

#endif /* TRKDOFVSDEFLHISTOACTION_H_ */
