/*
 * TofDedxVsBetaHistoAction.cpp
 *
 *  Created on: 25-giu-2009
 *      Author: Nicola Mori
 */

/*! @file TofDedxVsBetaHistoAction.cpp The TofDedxVsBetaHistoAction class implementation file. */

#include "TofDedxVsBetaHistoAction.h"

TofDedxVsBetaHistoAction::TofDedxVsBetaHistoAction(const char *actionName, unsigned int layers, bool standAlone,
    TString outFileBase, TString mode, bool outRoot, bool outText, TString title) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText), _layers(layers), _nLayers(0),
      _badEvents(0), _standAlone(standAlone) {

  if (title == "") {
    title = "TOF dE/dx (";
    if ((_layers & S11) == S11) {
      title += "S11";
      _nLayers++;
    }
    if ((_layers & S12) == S12) {
      if (_nLayers > 0)
        title += ",";
      title += "S12";
      _nLayers++;
    }
    if ((_layers & S21) == S21) {
      if (_nLayers > 0)
        title += ",";
      title += "S21";
      _nLayers++;
    }
    if ((_layers & S22) == S22) {
      if (_nLayers > 0)
        title += ",";
      title += "S22";
      _nLayers++;
    }
    if ((_layers & S31) == S31) {
      if (_nLayers > 0)
        title += ",";
      title += "S31";
      _nLayers++;
    }
    if ((_layers & S32) == S32) {
      if (_nLayers > 0)
        title += ",";
      title += "S32";
      _nLayers++;
    }
    title += ") Vs Beta";

    SetTitle(title);
  }

}

void TofDedxVsBetaHistoAction::OnGood(PamLevel2 *event) {

  static float dEdx;
  static float dEdxLayer;
  static unsigned int badLayers;

  static int trkSeqNo;
  if (_standAlone)
    trkSeqNo = 0;
  else
    for (int i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
      if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == event->GetTrack(0)->GetTrkTrack()->GetSeqNo())
        trkSeqNo = i;
    }

  dEdx = 0.;
  badLayers = 0;
  if ((_layers & S11) == S11) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 0, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if ((_layers & S12) == S12) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 1, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if ((_layers & S21) == S21) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 2, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if ((_layers & S22) == S22) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 3, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if ((_layers & S31) == S31) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 4, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if ((_layers & S32) == S32) {
    dEdxLayer = event->GetToFLevel2()->GetdEdx(trkSeqNo, 5, 100);
    if (dEdxLayer > 0. && dEdxLayer < 4090)
      dEdx += dEdxLayer;
    else
      badLayers++;
  }
  if (badLayers == 0) {
    dEdx /= _nLayers - badLayers;
    Fill(event->GetToFLevel2()->GetToFTrkVar(trkSeqNo)->beta[12], dEdx);
  }
  else
    _badEvents++;
}

