/*
 * TofBetaVsTrkBetaHistoAction.h
 *
 *  Created on: 15/set/2009
 *      Author: Nicola Mori
 */

/*! @file TofBetaVsTrkBetaHistoAction.h The TofBetaVsTrkBetaHistoAction class declaration file. */

#ifndef TOFBETAVSTRKBETAHISTOACTION_H_
#define TOFBETAVSTRKBETAHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a Tof Beta Vs. Trk Beta histogram.
 *
 * Beta from TRK is obtained from rigidity by:
 *
 * Beta_trk =  ( 1 / (1 + m^2/(ZR)^2) )^0.5
 */
class TofBetaVsTrkBetaHistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param mass The particle's mass.
   * @param charge The absolute value of the particle's charge.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TofBetaVsTrkBetaHistoAction(const char *actionName, float mass, unsigned int charge, TString outFileBase = "",
      TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "TOF Beta Vs. TRK Beta");

  /*! @brief Destructor */
  ~TofBetaVsTrkBetaHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:
  float _Z2;
  float _m2;
};
#endif /* TOFBETAVSTRKBETAHISTOACTION_H_ */
