/*
 * TofBetaVsTrkRigHistoAction.cpp
 *
 *  Created on: 15/set/2009
 *      Author: Nicola Mori
 */

#include "TofBetaVsTrkBetaHistoAction.h"

TofBetaVsTrkBetaHistoAction::TofBetaVsTrkBetaHistoAction(const char *actionName, float mass, unsigned int charge,
    TString outFileBase, TString mode, bool outRoot, bool outText, TString title) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText), _Z2(charge * charge), _m2(mass * mass) {
}

void TofBetaVsTrkBetaHistoAction::OnGood(PamLevel2 *event) {

  float ZR2 = pow(event->GetTrack(0)->GetTrkTrack()->GetRigidity(), 2) * _Z2;
  Fill(sqrt(ZR2 / (ZR2 + _m2)), event->GetTrack(0)->GetToFTrack()->beta[12]);
  //cout << sqrt(_m2) << "  " << sqrt(_Z2) << "  "  << event->GetTrack(0)->GetTrkTrack()->GetRigidity() << "  " << ZR2 << "  "<< sqrt(ZR2 / ZR2 + _m2) << "  " << event->GetTrack(0)->GetToFTrack()->beta[12] << endl;
}
