/*
 * SVCVsLHistoAction.h
 *
 *  Created on: 14/jan/2010
 *      Author: S. Ricciarini
 */

/*! @file SVCVsLHistoAction.h The SVCVsLHistoAction class declaration file. */

#ifndef SVCVSLHISTOACTION_H_
#define SVCVSLHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a Stoermer Vertical Cutoff vs. L shell histogram
 *
 */
class SVCVsLHistoAction: public Histo2DAction<Float_t> {

public:

   /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  SVCVsLHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE",
      bool outRoot = true, bool outText = true, TString title = "SVC vs. L");


  /*! @brief Destructor */
  ~SVCVsLHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};

#endif /* SVCVSLHISTOACTION_H_ */
