/*
 * GPYVsXT2HistoAction.h
 *
 *  Created on: 01/jun/2010
 *      Author: Sergio Ricciarini
 */

/*! @file GPYVsXT2HistoAction.h The GPYVsXT2HistoAction class declaration file. */

#ifndef GPYVSXT2HISTOACTION_H_
#define GPYVSXT2HISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a GPamela Y vs. X histogram for over TRK plane T2.
 *
 */
class GPYVsXT2HistoAction: public Histo2DAction<Int_t> {

public:

   /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  GPYVsXT2HistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE",
      bool outRoot = true, bool outText = true, TString title = "GP Y Vs X on T2");


  /*! @brief Destructor */
  ~GPYVsXT2HistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:

};

#endif /* GPYVSXT2HISTOACTION_H_ */
