/*
 * CaloAxisChi2VsRigHistoAction.cpp
 *
 *  Created on: 2010-02-22
 *      Author: S. Ricciarini
 */

/*! @file CaloAxisChi2VsRigHistoAction.cpp The CaloAxisChi2VsRigHistoAction class implementation file. */

#ifndef NO_CALOAXIS

#include "CaloAxisChi2VsRigHistoAction.h"

CaloAxisChi2VsRigHistoAction::CaloAxisChi2VsRigHistoAction(const char *actionName, CaloAxis *axis, TString outFileBase,
    TString mode, bool outRoot, bool outText, TString title) :
  Histo2DAction<Int_t> (actionName, title, outFileBase, mode, outRoot, outText), _axis(axis) {
}

void CaloAxisChi2VsRigHistoAction::OnGood(PamLevel2 *event) {

  Fill(1./event->GetTrack(0)->GetTrkTrack()->GetDeflection(), _axis->GetChi2());

}

#endif /* NO_CALOAXIS */
